/**
 * Copyright (C) 2012 - 2014, BMW AG
 *
 * This file is part of GENIVI Project AudioManager.
 *
 * Contributions are licensed to the GENIVI Alliance under one or more
 * Contribution License Agreements.
 *
 * \copyright
 * This Source Code Form is subject to the terms of the
 * Mozilla Public License, v. 2.0. If a  copy of the MPL was not distributed with
 * this file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *
 * \author Christian Linke, christian.linke@bmw.de BMW 2011 - 2014
 *
 * \file
 * For further information see http://projects.genivi.org/audio-manager
 *
 * THIS CODE HAS BEEN GENERATED BY ENTERPRISE ARCHITECT GENIVI MODEL.
 * PLEASE CHANGE ONLY IN ENTERPRISE ARCHITECT AND GENERATE AGAIN.
 */
#if !defined(EA_6B9C54C0_2366_4139_97CF_28563364DACA__INCLUDED_)
#define EA_6B9C54C0_2366_4139_97CF_28563364DACA__INCLUDED_

#include <vector>
#include <string>
#include "audiomanagertypes.h"

namespace am {
class CAmDbusWrapper;
class CAmSocketHandler;
}


#include "audiomanagertypes.h"

#define RoutingVersion "4.0"
namespace am {

/**
 * Routing Receive sendInterface description. This class implements everything
 * from RoutingAdapter -> Audiomanager
 * There are two rules that have to be kept in mind when implementing against this
 * interface:\n
 * \warning
 * 1. CALLS TO THIS INTERFACE ARE NOT THREAD SAFE !!!! \n
 * 2. YOU MAY NOT CALL THE CALLING INTERFACE DURING AN SYNCHRONOUS OR ASYNCHRONOUS
 * CALL THAT EXPECTS A RETURN VALUE.\n
 * \details
 * Violation these rules may lead to unexpected behavior! Nevertheless you can
 * implement thread safe by using the deferred-call pattern described on the wiki
 * which also helps to implement calls that are forbidden.\n
 * For more information, please check CAmSerializer
 */
class IAmRoutingReceive
{

public:
  IAmRoutingReceive() {

  }

  virtual ~IAmRoutingReceive() {

  }

  /**
   * This function returns the version of the interface
   */
  virtual void  getInterfaceVersion(std::string& version) const =0;
  /**
   * acknowledges a asyncConnect
   */
  virtual void ackConnect(const am_Handle_s handle, const am_connectionID_t connectionID, const am_Error_e error) =0;
  /**
   * acknowledges a asyncDisconnect
   */
  virtual void ackDisconnect(const am_Handle_s handle, const am_connectionID_t connectionID, const am_Error_e error) =0;
  /**
   * acknowledges a asyncsetSinkVolume
   */
  virtual void ackSetSinkVolumeChange(const am_Handle_s handle, const am_volume_t volume, const am_Error_e error) =0;
  /**
   * acknowledges a asyncsetSourceVolume
   */
  virtual void ackSetSourceVolumeChange(const am_Handle_s handle, const am_volume_t volume, const am_Error_e error) =0;
  /**
   * acknowlegde for asyncSetSourceState
   */
  virtual void ackSetSourceState(const am_Handle_s handle, const am_Error_e error) =0;
  /**
   * acknowledges asyncSetSinkSoundProperties
   */
  virtual void ackSetSinkSoundProperties(const am_Handle_s handle, const am_Error_e error) =0;
  /**
   * acknowledges asyncSetSinkSoundProperty
   */
  virtual void ackSetSinkSoundProperty(const am_Handle_s handle, const am_Error_e error) =0;
  /**
   * acknowledges asyncSetSourceSoundProperties
   */
  virtual void ackSetSourceSoundProperties(const am_Handle_s handle, const am_Error_e error) =0;
  /**
   * acknowledges asyncSetSourceSoundProperty
   */
  virtual void ackSetSourceSoundProperty(const am_Handle_s handle, const am_Error_e error) =0;
  /**
   * acknowledges asyncCrossFade
   */
  virtual void ackCrossFading(const am_Handle_s handle, const am_HotSink_e hotSink, const am_Error_e error) =0;
  /**
   * acknowledges a volume tick. This can be used to display volumechanges during
   * ramps
   */
  virtual void ackSourceVolumeTick(const am_Handle_s handle, const am_sourceID_t sourceID, const am_volume_t volume) =0;
  /**
   * acknowledges a volume tick. This can be used to display volumechanges during
   * ramps
   */
  virtual void ackSinkVolumeTick(const am_Handle_s handle, const am_sinkID_t sinkID, const am_volume_t volume) =0;
  /**
   * This function returns the ID to the given domainName. If already a domain is
   * registered with this name, it will return the corresponding ID, if not it will
   * reserve an ID but not register the domain. The other parameters of the domain
   * will be overwritten when the domain is registered.
   * @return E_OK on success, E_UNKNOWN on error
   */
  virtual am_Error_e peekDomain(const std::string& name, am_domainID_t& domainID) =0;
  /**
   * registers a domain
   * @return E_OK on succes, E_ALREADY_EXISTENT if already registered E_UNKOWN on
   * error
   */
  virtual am_Error_e registerDomain(const am_Domain_s& domainData, am_domainID_t& domainID) =0;
  /**
   * deregisters a domain. All sources, sinks, gateways and crossfaders from that
   * domain will be removed as well.
   * @return E_OK on succes, E_NON_EXISTENT if not found E_UNKOWN on error
   */
  virtual am_Error_e deregisterDomain(const am_domainID_t domainID) =0;
  /**
   * registers a converter. @return E_OK on succes, E_ALREADY_EXISTENT if already
   * registered E_UNKOWN on error
   */
  virtual am_Error_e registerConverter(const am_Converter_s& converterData, am_converterID_t& converterID) =0;
  /**
   * registers a gateway. @return E_OK on succes, E_ALREADY_EXISTENT if already
   * registered E_UNKOWN on error
   */
  virtual am_Error_e registerGateway(const am_Gateway_s& gatewayData, am_gatewayID_t& gatewayID) =0;
  /**
   * deregisters a converter. Also removes all sinks and sources of the controlling
   * domain.
   * @return E_OK on succes, E_NON_EXISTENT if not found E_UNKOWN on error
   */
  virtual am_Error_e deregisterConverter(const am_converterID_t converterID) =0;
  /**
   * deregisters a gateway. Also removes all sinks and sources of the controlling
   * domain.
   * @return E_OK on succes, E_NON_EXISTENT if not found E_UNKOWN on error
   */
  virtual am_Error_e deregisterGateway(const am_gatewayID_t gatewayID) =0;
  /**
   * This function returns the ID to the given sinkName. If already a sink is
   * registered with this name, it will return the corresponding ID, if not it will
   * reserve an ID but not register the sink. The other parameters of the sink will
   * be overwritten when the sink is registered.
   * @return E_OK on success, E_UNKNOWN on error
   */
  virtual am_Error_e peekSink(const std::string& name, am_sinkID_t& sinkID) =0;
  /**
   * Registers a sink. If the sink is part of a gateway, the listconnectionFormats
   * is copied to the gatewayInformation
   * @return E_OK on succes, E_ALREADY_EXISTENT if already registered E_UNKOWN on
   * error
   */
  virtual am_Error_e registerSink(const am_Sink_s& sinkData, am_sinkID_t& sinkID) =0;
  /**
   * deregisters a sink.
   * @return E_OK on succes, E_NON_EXISTENT if not found E_UNKOWN on error
   */
  virtual am_Error_e deregisterSink(const am_sinkID_t sinkID) =0;
  /**
   * This function returns the ID to the given sourceName. If already a source is
   * registered with this name, it will return the corresponding ID, if not it will
   * reserve an ID but not register the source. The other parameters of the source
   * will be overwritten when the source is registered.
   * @return E_OK on success, E_UNKNOWN on error
   */
  virtual am_Error_e peekSource(const std::string& name, am_sourceID_t& sourceID) =0;
  /**
   * registers a source.  If the source is part of a gateway, the
   * listconnectionFormats is copied to the gatewayInformation
   * @return E_OK on success, E_UNKNOWN on error, E_ALREADY_EXIST if either name or
   * sourceID already exists
   */
  virtual am_Error_e registerSource(const am_Source_s& sourceData, am_sourceID_t& sourceID) =0;
  /**
   * deregisters a source
   * @return E_OK on succes, E_NON_EXISTENT if not found E_UNKOWN on error
   */
  virtual am_Error_e deregisterSource(const am_sourceID_t sourceID) =0;
  /**
   * this function registers a crossfader.
   * @return E_OK on succes, E_ALREADY_EXISTENT if already registered E_UNKOWN on
   * error
   */
  virtual am_Error_e registerCrossfader(const am_Crossfader_s& crossfaderData, am_crossfaderID_t& crossfaderID) =0;
  /**
   * this function deregisters a crossfader. removes all sources and sinks assiated
   * as well.
   * @return E_OK on succes, E_NON_EXISTENT if not found E_UNKOWN on error
   */
  virtual am_Error_e deregisterCrossfader(const am_crossfaderID_t crossfaderID) =0;
  /**
   * this function peeks a sourceclassID. It is used by the RoutingPlugins to
   * determine the SinkClassIDs of a sinkClass.
   * @return E_OK on succes, E_DATABASE_ERROR on error
   */
  virtual am_Error_e peekSourceClassID(const std::string& name, am_sourceClass_t& sourceClassID) =0;
  /**
   * this function peeks a sourceclassID. It is used by the RoutingPlugins to
   * determine the SinkClassIDs of a sinkClass.
   * @return E_OK on succes, E_DATABASE_ERROR on error
   */
  virtual am_Error_e peekSinkClassID(const std::string& name, am_sinkClass_t& sinkClassID) =0;
  /**
   * is called when a low level interrupt changes it status.
   */
  virtual void hookInterruptStatusChange(const am_sourceID_t sourceID, const am_InterruptState_e interruptState) =0;
  /**
   * This hook is called when all elements from a domain are registered.
   * Is used by the Controller to know when all expected domains are finally
   * registered
   */
  virtual void hookDomainRegistrationComplete(const am_domainID_t domainID) =0;
  /**
   * is called when a sink changes its availability
   */
  virtual void hookSinkAvailablityStatusChange(const am_sinkID_t sinkID, const am_Availability_s& availability) =0;
  /**
   * is called when a source changes its availability
   */
  virtual void hookSourceAvailablityStatusChange(const am_sourceID_t sourceID, const am_Availability_s& availability) =0;
  /**
   * is called when a domain changes its status. This used for early domains only
   */
  virtual void hookDomainStateChange(const am_domainID_t domainID, const am_DomainState_e domainState) =0;
  /**
   * is called when the timinginformation (delay) changed for a connection.
   */
  virtual void hookTimingInformationChanged(const am_connectionID_t connectionID, const am_timeSync_t delay) =0;
  /**
   * this function is used to send out all data that has been changed in an early
   * state.
   * @return E_OK on success, E_UNKNOWN on error
   */
  virtual void sendChangedData(const std::vector<am_EarlyData_s>& earlyData) =0;
  /**
   * this function is used to retrieve a pointer to the dBusConnectionWrapper
   * @return E_OK if pointer is valid, E_UKNOWN if AudioManager was compiled without
   * DBus Support
   */
  virtual am_Error_e getDBusConnectionWrapper(CAmDbusWrapper*& dbusConnectionWrapper) const =0;
  /**
   * This function returns the pointer to the socketHandler. This can be used to
   * integrate socket-based activites like communication with the mainloop of the
   * AudioManager.
   * returns E_OK if pointer is valid, E_UNKNOWN in case AudioManager was compiled
   * without socketHandler support,
   */
  virtual am_Error_e getSocketHandler(CAmSocketHandler*& socketHandler) const =0;
  /**
   * confirms the setRoutingReady Command
   */
  virtual void  confirmRoutingReady(const uint16_t handle, const am_Error_e error) =0;
  /**
   * confirms the setRoutingRundown Command
   */
  virtual void  confirmRoutingRundown(const uint16_t handle, const am_Error_e error) =0;
  /**
   * updates data of an converter. @return E_OK on success, E_NON_EXISTENT if the
   * gatewayID is not valid.
   */
  virtual am_Error_e updateConverter(const am_converterID_t converterID, const std::vector<am_CustomConnectionFormat_t>& listSourceFormats, const std::vector<am_CustomConnectionFormat_t>& listSinkFormats, const std::vector<bool>& convertionMatrix) =0;
  /**
   * updates data of an gateway. @return E_OK on success, E_NON_EXISTENT if the
   * gatewayID is not valid.
   */
  virtual am_Error_e updateGateway(const am_gatewayID_t gatewayID, const std::vector<am_CustomConnectionFormat_t>& listSourceFormats, const std::vector<am_CustomConnectionFormat_t>& listSinkFormats, const std::vector<bool>& convertionMatrix) =0;
  /**
   * updates data of an gateway. @return E_OK on success, E_NON_EXISTENT if the
   * sinkID is not valid.
   */
  virtual am_Error_e updateSink(const am_sinkID_t sinkID, const am_sinkClass_t sinkClassID, const std::vector<am_SoundProperty_s>& listSoundProperties, const std::vector<am_CustomConnectionFormat_t>& listConnectionFormats, const std::vector<am_MainSoundProperty_s>& listMainSoundProperties) =0;
  /**
   * updates data of an source. @return E_OK on success, E_NON_EXISTENT if the
   * sourceID in the struct is not valid.
   * Please note that only the following data out of am_Source_s have effect when
   * they are changed:
   * sourceClassID,
   * listSoundProperties,
   * listConnectionFormats,
   * listMainSoundProperties
   */
  virtual am_Error_e updateSource(const am_sourceID_t sourceID, const am_sourceClass_t sourceClassID, const std::vector<am_SoundProperty_s>& listSoundProperties, const std::vector<am_CustomConnectionFormat_t>& listConnectionFormats, const std::vector<am_MainSoundProperty_s>& listMainSoundProperties) =0;
  /**
   * acknowledges a asyncSetSinkVolumes
   */
  virtual void ackSetVolumes(const am_Handle_s handle, const std::vector<am_Volumes_s>& listvolumes, const am_Error_e error) =0;
  /**
   * The acknowledge of the SinkNotificationConfiguration
   */
  virtual void ackSinkNotificationConfiguration(const am_Handle_s handle, const am_Error_e error) =0;
  /**
   * The acknowledge of the SourceNotificationConfiguration
   */
  virtual void ackSourceNotificationConfiguration(const am_Handle_s handle, const am_Error_e error) =0;
  /**
   * is called whenever a notified value needs to be send
   */
  virtual void hookSinkNotificationDataChange(const am_sinkID_t sinkID, const am_NotificationPayload_s& payload) =0;
  /**
   * is called whenever a notified value needs to be send
   */
  virtual void hookSourceNotificationDataChange(const am_sourceID_t sourceID, const am_NotificationPayload_s& payload) =0;
  /**
   * E_OK in case of success
   */
  virtual am_Error_e getDomainOfSink(const am_sinkID_t sinkID, am_domainID_t& domainID) const =0;
  /**
   * E_OK in case of success
   */
  virtual am_Error_e getDomainOfSource(const am_sourceID_t sourceID, am_domainID_t& domainID) const =0;
  /**
   * E_OK in case of success
   */
  virtual am_Error_e getDomainOfCrossfader(const am_crossfaderID_t crossfader, am_domainID_t& domainID) const = 0;

};

/**
 * This class implements everything from Audiomanager -> RoutingAdapter
 * There are two rules that have to be kept in mind when implementing against this
 * interface:\n
 * \warning
 * 1. CALLS TO THIS INTERFACE ARE NOT THREAD SAFE !!!! \n
 * 2. YOU MAY NOT CALL THE CALLING INTERFACE DURING AN SYNCHRONOUS OR ASYNCHRONOUS
 * CALL THAT EXPECTS A RETURN VALUE.\n
 * \details
 * Violation these rules may lead to unexpected behavior! Nevertheless you can
 * implement thread safe by using the deferred-call pattern described on the wiki
 * which also helps to implement calls that are forbidden.\n
 * For more information, please check CAmSerializer
 */
class IAmRoutingSend
{

public:
  IAmRoutingSend() {

  }

  virtual ~IAmRoutingSend() {

  }

  /**
   * This function returns the version of the interface
   */
  virtual void getInterfaceVersion(std::string& version) const =0;
  /**
   * starts up the interface. In the implementations, here is the best place for
   * init routines.
   */
  virtual am_Error_e startupInterface(IAmRoutingReceive* routingreceiveinterface) =0;
  /**
   * indicates that the routing now ready to be used. Should be used as trigger to
   * register all sinks, sources, etc...
   */
  virtual void setRoutingReady(const uint16_t handle) =0;
  /**
   * indicates that the routing plugins need to be prepared to switch the power off
   * or be ready again.
   */
  virtual void setRoutingRundown(const uint16_t handle) =0;
  /**
   * aborts an asynchronous action.
   * @return E_OK on success, E_UNKNOWN on error, E_NON_EXISTENT if handle was not
   * found
   */
  virtual am_Error_e asyncAbort(const am_Handle_s handle) =0;
  /**
   * connects a source to a sink
   * @return E_OK on success, E_UNKNOWN on error, E_WRONG_FORMAT in case
   * am_ConnectionFormat_e does not match
   */
  virtual am_Error_e asyncConnect(const am_Handle_s handle, const am_connectionID_t connectionID, const am_sourceID_t sourceID, const am_sinkID_t sinkID, const am_CustomConnectionFormat_t connectionFormat) =0;
  /**
   * disconnect a connection with given connectionID
   * @return E_OK on success, E_UNKNOWN on error, E_NON_EXISTENT if connection was
   * not found
   */
  virtual am_Error_e asyncDisconnect(const am_Handle_s handle, const am_connectionID_t connectionID) =0;
  /**
   * this method is used to set the volume of a sink. This function is used to drive
   * ramps, to mute or unmute or directly set the value. The difference is made
   * through the ramptype.
   * @return E_OK on success, E_UNKNOWN on error, E_OUT_OF_RANGE if new volume is
   * out of range
   */
  virtual am_Error_e asyncSetSinkVolume(const am_Handle_s handle, const am_sinkID_t sinkID, const am_volume_t volume, const am_CustomRampType_t ramp, const am_time_t time) =0;
  /**
   * sets the volume of a source. This method is used to set the volume of a sink.
   * This function is used to drive ramps, to mute or unmute or directly set the
   * value. The difference is made through the ramptype.
   * @return E_OK on success, E_UNKNOWN on error, E_OUT_OF_RANGE if volume is out of
   * range.
   * triggers the acknowledge ackSourceVolumeChange
   */
  virtual am_Error_e asyncSetSourceVolume(const am_Handle_s handle, const am_sourceID_t sourceID, const am_volume_t volume, const am_CustomRampType_t ramp, const am_time_t time) =0;
  /**
   * This function is used to set the source state of a particular source.
   * @return E_OK on success, E_UNKNOWN on error
   */
  virtual am_Error_e asyncSetSourceState(const am_Handle_s handle, const am_sourceID_t sourceID, const am_SourceState_e state) =0;
  /**
   * this function sets the sinksoundproperty.
   * @return E_OK on success, E_UNKNOWN on error, E_OUT_OF_RANGE in case the propery
   * value is out of range
   */
  virtual am_Error_e asyncSetSinkSoundProperties(const am_Handle_s handle, const am_sinkID_t sinkID, const std::vector<am_SoundProperty_s>& listSoundProperties) =0;
  /**
   * this function sets the sinksoundproperty.
   * @return E_OK on success, E_UNKNOWN on error, E_OUT_OF_RANGE in case the propery
   * value is out of range
   */
  virtual am_Error_e asyncSetSinkSoundProperty(const am_Handle_s handle, const am_sinkID_t sinkID, const am_SoundProperty_s& soundProperty) =0;
  /**
   * this function sets the sourcesoundproperty.
   * @return E_OK on success, E_UNKNOWN on error, E_OUT_OF_RANGE in case the propery
   * value is out of range
   */
  virtual am_Error_e asyncSetSourceSoundProperties(const am_Handle_s handle, const am_sourceID_t sourceID, const std::vector<am_SoundProperty_s>& listSoundProperties) =0;
  /**
   * this function sets the sourcesoundproperty.
   * @return E_OK on success, E_UNKNOWN on error, E_OUT_OF_RANGE in case the propery
   * value is out of range
   */
  virtual am_Error_e asyncSetSourceSoundProperty(const am_Handle_s handle, const am_sourceID_t sourceID, const am_SoundProperty_s& soundProperty) =0;
  /**
   * this function triggers crossfading.
   * @return E_OK on success, E_UNKNOWN on error
   */
  virtual am_Error_e asyncCrossFade(const am_Handle_s handle, const am_crossfaderID_t crossfaderID, const am_HotSink_e hotSink, const am_CustomRampType_t rampType, const am_time_t time) =0;
  /**
   * this function is used for early and late audio functions to set the domain
   * state
   * @return E_OK on success, E_UNKNOWN on error
   */
  virtual am_Error_e setDomainState(const am_domainID_t domainID, const am_DomainState_e domainState) =0;
  /**
   * this method is used to retrieve the busname during startup of the plugin. Needs
   * to be implemented
   * @return E_OK on success, E_UNKNOWN on error
   */
  virtual am_Error_e returnBusName(std::string& BusName) const =0;
  /**
   * This command sets multiple source or and sink volumes within a domain at a time.
   * It can be used to synchronize volume setting events.
   * @return E_OK on success, E_UNKNOWN on error.
   */
  virtual am_Error_e asyncSetVolumes(const am_Handle_s handle, const std::vector<am_Volumes_s>& listVolumes) =0;
  /**
   * sets the notification configuration of a sink.
   * @return E_OK on success, E_UNKNOWN on error.
   */
  virtual am_Error_e asyncSetSinkNotificationConfiguration(const am_Handle_s handle, const am_sinkID_t sinkID, const am_NotificationConfiguration_s& notificationConfiguration) =0;
  /**
   * sets the notification configuration of a source.
   * @return E_OK on success, E_UNKNOWN on error.
   */
  virtual am_Error_e asyncSetSourceNotificationConfiguration(const am_Handle_s handle, const am_sourceID_t sourceID, const am_NotificationConfiguration_s& notificationConfiguration) =0;

};
}
#endif // !defined(EA_6B9C54C0_2366_4139_97CF_28563364DACA__INCLUDED_)
